/*****************************************************************************************************/
/*  INEP/CETIC-Centro de Tecnologia, Inovao e Cincia de Dados                             */ 
/*                                   			                                    */
/*  Coordenao-Geral de Sistemas e Dados Educacionais (CGSDE)		*/
/*----------------------------------------------------------------------------------------------------------------------------*/
/*  PROGRAMA:                                                                                                      */
/*           INPUT_SPSS_INPUT_TS_ITEM_2024                                        	*/
/*----------------------------------------------------------------------------------------------------------------------------*/
/*DESCRICAO: PROGRAMA PARA LEITURA DA BASE DE ITENS		*/
/* TS_ITEM  		   				*/
/*****************************************************************************************************/
/*****************************************************************************************************/
/* Obs:                                                                                                                    */
/* 		                                                                                           */
/* Para abrir os microdados  necessrio salvar este programa e o arquivo                    */
/* TS_ITEM.csv no diretrio C:\ do computador.		                             	 */
/*							 */ 
/*							 */
/* Para a leitura dos microdados  necessrio a seleo do programa abaixo,               */
/* depois execute-o.						 */
/*							 */ 
/******************************************************************************************************/
/*                                                   ATENO                                                          */ 
/******************************************************************************************************/
/* Este programa abre a base de dados com os rtulos das variveis de	                    */
/* acordo com o dicionrio de dados que compem os microdados. Para abrir                */
/* os dados sem os rtulos basta importar diretamente no SPSS.		  */
/* 							   */
/*******************************************************************************************************/
 
GET DATA
  /TYPE=TXT
  /FILE= "C:\TS_ITEM.csv" /*local do arquivo*/ 
  /DELCASE=LINE
  /DELIMITERS=";"
  /ARRANGEMENT=DELIMITED
  /FIRSTCASE=2
  /IMPORTCASE= ALL
  /VARIABLES=
  NU_ANO_AVALIACAO F4.0
  CO_UF F2.0
  SG_UF A2
  CO_BLOCO F2.0
  NU_POSICAO F2.0
  CO_ITEM F6.0
  TP_SERIE F1.0
  TP_DISCIPLINA F1.0
  NU_DESCRITOR_HABILIDADE A5
  DS_GABARITO A1
  TP_RESPOSTA_ITEM F1.0
  TP_MODELO_TRI F1.0
  NU_PARAM_A COMMA6.5
  NU_PARAM_B COMMA6.5
  NU_PARAM_C COMMA6.5
  NU_PARAM_B1 COMMA6.5
  NU_PARAM_B2 COMMA6.5
  NU_PARAM_B3 COMMA6.5
  NU_PARAM_B4 COMMA6.5
  IN_ITEM_COMUM F1.0.

CACHE.
EXECUTE.
DATASET NAME TS_ITEM_2024 WINDOW=FRONT.

VARIABLE LABELS
  NU_ANO_AVALIACAO "Ano de aplicao da avaliao estadual"
  CO_UF            	"Cdigo da Unidade da Federao"
  SG_UF            	"Sigla da Unidade da Federao"
  CO_BLOCO         	"Cdigo do Bloco"
  NU_POSICAO       	"Posio do item no Bloco."
  CO_ITEM          	"Cdigo do item"
  TP_SERIE         	"Ano Escolar"
  TP_DISCIPLINA    	"Indica a disciplina a que corresponde o item"
  NU_DESCRITOR_HABILIDADE "Identificador do descritor do item"
  DS_GABARITO      	"Gabarito do Item"
  TP_RESPOSTA_ITEM 	"Tipo de resposta esperada para o Item"
  TP_MODELO_TRI    	"Modelos da Teoria de Resposta ao Item"
  NU_PARAM_A       	"Parmetro de discriminao."
  NU_PARAM_B       	"Parmetro de dificuldade."
  NU_PARAM_C       	"Parmetro de acerto ao acaso."
  NU_PARAM_B1      	"Parmetro de dificuldade da transio entre as categorias de erro e acerto parcial."
  NU_PARAM_B2      	"Parmetro de dificuldade da transio entre as categorias de acerto parcial e acerto total."
  NU_PARAM_B3      	"Parmetro de dificuldade da transio entre as categorias de acerto parcial e acerto total."
  NU_PARAM_B4      	"Parmetro de dificuldade da transio entre as categorias de acerto parcial e acerto total."
  IN_ITEM_COMUM	"Indica se  um item comum com a avaliao do SAEB".
 
VALUE LABELS
  TP_SERIE
     2  "2 ano do Ensino Fundamental"
  /TP_DISCIPLINA
    1  "Lngua Portuguesa (LP)"
  /TP_RESPOSTA_ITEM
    1  "Produo Textual"
    2  "Resposta Construda"
    3  "Resposta Objetiva"
    4  "Resposta Construda com Quesito"
  /TP_MODELO_TRI
    1  "M2PL: Modelo logstico de 2 parmetros"
    2  "M3PL: Modelo Logstico de 3 parmetros"
    3  "MRG: Modelo de resposta gradual"
    4  "M3P: modelo normal de 3 parmetros"
  /IN_ITEM_COMUM
    0  "No"
    1  "Sim".