/*****************************************************************************************************/
/*  INEP/CETIC-Centro de Tecnologia, Inovao e Cincia de Dados                             */ 
/*                                   			                                    */
/*  Coordenao-Geral de Sistemas e Dados Educacionais (CGSDE)		*/
/*----------------------------------------------------------------------------------------------------------------------------*/
/*  PROGRAMA:                                                                                                      */
/*           INPUT_SPSS_INPUT_TS_ESTADO_2024                                        	*/
/*----------------------------------------------------------------------------------------------------------------------------*/
/*DESCRICAO: PROGRAMA PARA LEITURA DA BASE DE ESTADOS (UFS)	*/
/* TS_ESTADO		   				*/
/*****************************************************************************************************/
/*****************************************************************************************************/
/* Observao:                                                                                                         */
/* 		                                                                                           */
/* Para abrir os microdados  necessrio salvar este programa e o arquivo                    */
/* TS_ESTADO.csv no diretrio C:\ do computador.		                   */
/*							 */ 
/*							 */
/* Para a leitura dos microdados  necessrio a seleo do programa abaixo,               */
/* depois execute-o.						 */
/*							 */ 
/******************************************************************************************************/
/*                                                   ATENO                                                          */ 
/******************************************************************************************************/
/* Este programa abre a base de dados com os rtulos das variveis de	                    */
/* acordo com o dicionrio de dados que compem os microdados. Para abrir                */
/* os dados sem os rtulos basta importar diretamente no SPSS.		  */
/* 							   */
/*******************************************************************************************************/
 
GET DATA
  /TYPE=TXT
  /FILE= "C:\TS_ESTADO.csv" /*local do arquivo*/ 
  /DELCASE=LINE
  /DELIMITERS=";"
  /ARRANGEMENT=DELIMITED
  /FIRSTCASE=2
  /IMPORTCASE= ALL
  /VARIABLES=
  NU_ANO_AVALIACAO F4.0
  CO_UF F2.0
  SG_UF A2
  TP_SERIE F1.0
  ID_TIPO_REDE F1.0
  PC_ALUNO_ALFABETIZADO COMMA5.2
  VL_MEDIA_LP COMMA8.4
  PC_ALUNO_NIVEL_0_LP COMMA5.2
  PC_ALUNO_NIVEL_1_LP COMMA5.2
  PC_ALUNO_NIVEL_2_LP COMMA5.2
  PC_ALUNO_NIVEL_3_LP COMMA5.2
  PC_ALUNO_NIVEL_4_LP COMMA5.2
  PC_ALUNO_NIVEL_5_LP COMMA5.2
  PC_ALUNO_NIVEL_6_LP COMMA5.2
  PC_ALUNO_NIVEL_7_LP COMMA5.2
  PC_ALUNO_NIVEL_8_LP COMMA5.2.

CACHE.
EXECUTE.
DATASET NAME TS_ESTADO_2024 WINDOW=FRONT.

VARIABLE LABELS
  NU_ANO_AVALIACAO 	 "Ano de aplicao da avaliao estadual"
  CO_UF            		 "Cdigo da Unidade da Federao"
  SG_UF            		 "Sigla da Unidade da Federao"
  TP_SERIE         		 "Ano Escolar"
  ID_TIPO_REDE     		 "Rede de ensino avaliada para construo do resultado"
  PC_ALUNO_ALFABETIZADO 	 "Percentual dos alunos avalados no Municpio que foram considerados, mediante o resultado da avaliao estadual, como alfabetizados."
  VL_MEDIA_LP      		 "Mdia ponderada do Municpio na avaliao estadual na disciplina Lngua Portuguesa (LP) equalizada com o SAEB."
  PC_ALUNO_NIVEL_0_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 0 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_1_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 1 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_2_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 2 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_3_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 3 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_4_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 4 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_5_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 5 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_6_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 6 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_7_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 7 na avaliao estadual de Lingua Portuguesa (LP)."
  PC_ALUNO_NIVEL_8_LP 	"Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 8 na avaliao estadual de Lingua Portuguesa (LP).".
 
VALUE LABELS
  TP_SERIE
    2 "2 ano do Ensino Fundamental"
  /ID_TIPO_REDE
    1  "Federal"
    2  "Estadual"
    3  "Municipal"
    4  "Privada"
    5  "Pblica (Estadual e Municipal)"
    6  "Pblica (Federal, Estadual e Municipal)".