/*****************************************************************************************************/
/*  INEP/CETIC-Centro de Tecnologia, Inovao e Cincia de Dados                             */ 
/*                                   			                                    */
/*  Coordenao-Geral de Sistemas e Dados Educacionais (CGSDE)		*/
/*----------------------------------------------------------------------------------------------------------------------------*/
/*  PROGRAMA:                                                                                                      */
/*           INPUT_SPSS_INPUT_TS_ALUNO_2024                                        	*/
/*----------------------------------------------------------------------------------------------------------------------------*/
/*DESCRICAO: PROGRAMA PARA LEITURA DA BASE DE ALUNOS		*/
/* TS_ALUNO  		   				*/
/*****************************************************************************************************/
/*****************************************************************************************************/
/* Obs:                                                                                                                    */
/* 		                                                                                           */
/* Para abrir os microdados  necessrio salvar este programa e o arquivo                    */
/* TS_ALUNO.csv no diretrio C:\ do computador.		                             	 */
/*							 */ 
/*							 */
/* Para a leitura dos microdados  necessrio a seleo do programa abaixo,               */
/* depois execute-o.						 */
/*							 */ 
/******************************************************************************************************/
/*                                                   ATENO                                                          */ 
/******************************************************************************************************/
/* Este programa abre a base de dados com os rtulos das variveis de	                    */
/* acordo com o dicionrio de dados que compem os microdados. Para abrir                */
/* os dados sem os rtulos basta importar diretamente no SPSS.		  */
/* 							   */
/*******************************************************************************************************/
 
GET DATA
  /TYPE=TXT
  /FILE= "C:\TS_ALUNO.csv" /*local do arquivo*/ 
  /DELCASE=LINE
  /DELIMITERS=";"
  /ARRANGEMENT=DELIMITED
  /FIRSTCASE=2
  /IMPORTCASE= ALL
  /VARIABLES=
  NU_ANO_AVALIACAO F4.0
  CO_UF F2.0
  SG_UF A2
  ID_ALUNO F8.0
  TP_SERIE F1.0
  ID_ESCOLA F8.0
  TP_DEPENDENCIA F1.0
  CO_MUNICIPIO F7.0
  NO_MUNICIPIO A32
  IN_PRESENCA_LP F1.0
  IN_PREENCHIMENTO_LP F1.0
  CO_CADERNO_LP F2.0
  VL_PESO_ALUNO_LP COMMA12.7
  VL_PROFICIENCIA_LP COMMA10.7
  IN_ALFABETIZADO F1.0.

CACHE.
EXECUTE.
DATASET NAME TS_ALUNO_2024 WINDOW=FRONT.

VARIABLE LABELS
  NU_ANO_AVALIACAO 	 "Ano de aplicao da avaliao estadual"
  CO_UF            		 "Cdigo da Unidade da Federao"
  SG_UF            		 "Sigla da Unidade da Federao"
  ID_ALUNO         		 "Identificador do Aluno"
  TP_SERIE         		 "Ano Escolar"
  ID_ESCOLA        		 "Mscara do Cdigoo da Escola (cdigos fictcios)"
  TP_DEPENDENCIA		 "Dependncia Administrativa da Escola"
  CO_MUNICIPIO     		 "Cdigo do Municpio onde est localizada a escola."
  NO_MUNICIPIO     	 	"Nome do Municpio onde est localizada a escola."
  IN_PRESENCA_LP   	 	"Indicador de presena na prova de Lngua Portuguesa (LP). "
  IN_PREENCHIMENTO_LP 	"Indicador de preenchimento da prova de Lngua Portuguesa (LP). "
  CO_CADERNO_LP    	 	"Cdigo do Caderno atribudo ao aluno na prova de Lngua Portuguesa (LP)."
  VL_PESO_ALUNO_LP 	 "Peso do aluno na prova de Lngua Portuguesa"
  VL_PROFICIENCIA_LP  	"Proficincia do aluno em Lngua Portuguesa (LP) calculada na escala equalizada com o SAEB."
  IN_ALFABETIZADO  	 	"Indica se o aluno, mediante o resultado da avaliao estadual,  considerado alfabetizado.".
 
VALUE LABELS
  TP_SERIE
    2 "2 ano do Ensino Fundamental"
  /TP_DEPENDENCIA
    1  "Federal"
    2  "Estadual"
    3  "Municipal"
    4  "Privada"
 /IN_PRESENCA_LP
    0 "Ausente"
    1 "Presente"
  /IN_PREENCHIMENTO_LP
     0 "Prova no preenchida"
     1 "Prova preenchida"
  /IN_ALFABETIZADO
     0 "No"
     1 "Sim".