/**************************************************************************/
/*  INEP/CETIC - Centro de Tecnologia, Inovao e Cincia de Dados     	  */      
/*                                   									  */	
/*  Coordenao-Geral de Sistemas e Dados Educacionais (CGSDE)			  */
/*------------------------------------------------------------------------*/
/*  PROGRAMA:                                                             */
/*           INPUT_SAS_TS_ITEM_2024.sas	                          	  	  */
/*------------------------------------------------------------------------*/
/* DESCRICAO: PROGRAMA PARA LEITURA DA TABELA TS_ITEM DOS MICRODADOS DA   */
/* AEEB 2024                                                           */    
/*                                                                        */
/**************************************************************************/
/**************************************************************************/
/* Observao:                                                            */
/* 		                                                                  */
/* Para abrir os microdados  necessrio salvar este programa e o arquivo */
/* TS_ITEM.csv no diretrio C:\ do computador.				              */
/*															 			  */                                           
/* Ao terminar esses procedimentos execute o programa salvo utilizando    */
/* as variveis de interesse.                                             */
/**************************************************************************/
/*				                  ATENO                                 */  
/**************************************************************************/
/* Este programa abre a base de itens com os rtulos das variveis de	  */
/* acordo com o dicionrio de dados que compem os microdados. Para abrir */
/* os dados sem os rtulos basta importar diretamente no SAS.			  */
/* 																	      */ 																          
/**************************************************************************/

proc format;
	Value TP_SERIE
			2='2 ano do Ensino Fundamental';

	Value TP_DISCIPLINA
			1 = 'Lngua Portuguesa (LP)';

	Value TP_RESPOSTA_ITEM
			1 = 'Produo Textual'
			2 = 'Resposta Construda'
			3 = 'Resposta Objetiva'
			4 = 'Resposta Construda com Quesito';

	Value TP_MODELO_TRI
			1 = 'M2PL: Modelo logstico de 2 parmetros'
			2 = 'M3PL: Modelo Logstico de 3 parmetros'
			3 = 'MRG: Modelo de resposta gradual'
			4 = 'M3P: modelo normal de 3 parmetros';

	Value IN_ITEM_COMUM
			0 = 'No'
			1 = 'Sim';

DATA WORK.TS_ITEM_2024;
	INFILE 'C:\TS_ITEM.csv' /*local do arquivo*/
	    LRECL=200
	    FIRSTOBS=2
	    DLM=';'
	    MISSOVER
	    DSD;

INPUT
        NU_ANO_AVALIACAO 		: ?? BEST4.
        CO_UF            		: ?? BEST2.
        SG_UF            		: $CHAR2.
        CO_BLOCO         		: ?? BEST2.
        NU_POSICAO       		: ?? BEST2.
        CO_ITEM          		: ?? BEST6.
        TP_SERIE         		: ?? BEST1.
        TP_DISCIPLINA    		: ?? BEST1.
        NU_DESCRITOR_HABILIDADE : $CHAR5.
        DS_GABARITO      		: $CHAR1.
        TP_RESPOSTA_ITEM 		: ?? BEST1.
        TP_MODELO_TRI    		: ?? BEST1.
        NU_PARAM_A       		: ?? COMMA7.
        NU_PARAM_B       		: ?? COMMA7.
        NU_PARAM_C       		: ?? COMMA7.
        NU_PARAM_B1      		: ?? COMMA7.
        NU_PARAM_B2      		: ?? COMMA7.
        NU_PARAM_B3      		: ?? COMMA7.
        NU_PARAM_B4      		: ?? COMMA7.
        IN_ITEM_COMUM    		: ?? BEST1. ;

ATTRIB  
        TP_SERIE			FORMAT = TP_SERIE.          
        TP_DISCIPLINA    	FORMAT = TP_DISCIPLINA. 
		TP_RESPOSTA_ITEM	FORMAT = TP_RESPOSTA_ITEM.
		TP_MODELO_TRI		FORMAT = TP_MODELO_TRI.
		IN_ITEM_COMUM		FORMAT = IN_ITEM_COMUM.;

LABEL
		NU_ANO_AVALIACAO 	= 'Ano de aplicao da avaliao estadual'
		CO_UF            	= 'Cdigo da Unidade da Federao'
		SG_UF            	= 'Sigla da Unidade da Federao'
		CO_BLOCO         	= 'Cdigo do Bloco'
		NU_POSICAO       	= 'Posio do item no Bloco.'
		CO_ITEM          	= 'Cdigo do item'
		TP_SERIE         	= 'Ano Escolar'
		TP_DISCIPLINA    	= 'Indica a disciplina a que corresponde o item'
		NU_DESCRITOR_HABILIDADE = 'Identificador do descritor do item'
		DS_GABARITO      	= 'Gabarito do Item'
		TP_RESPOSTA_ITEM 	= 'Tipo de resposta esperada para o Item'
		TP_MODELO_TRI    	= 'Modelos da Teoria de Resposta ao Item'
		NU_PARAM_A       	= 'Parmetro de discriminao.'
		NU_PARAM_B       	= 'Parmetro de dificuldade.'
		NU_PARAM_C       	= 'Parmetro de acerto ao acaso.'
		NU_PARAM_B1      	= 'Parmetro de dificuldade da transio entre as categorias de erro e acerto parcial.'
		NU_PARAM_B2      	= 'Parmetro de dificuldade da transio entre as categorias de acerto parcial e acerto total.'
		NU_PARAM_B3      	= 'Parmetro de dificuldade da transio entre as categorias de acerto parcial e acerto total.'
		NU_PARAM_B4      	= 'Parmetro de dificuldade da transio entre as categorias de acerto parcial e acerto total.'
		IN_ITEM_COMUM		= 'Indica se  um item comum com a avaliao do SAEB';
RUN;