/**************************************************************************/
/*  INEP/CETIC - Centro de Tecnologia, Inovao e Cincia de Dados     	  */      
/*                                   									  */	
/*  Coordenao-Geral de Sistemas e Dados Educacionais (CGSDE)			  */
/*------------------------------------------------------------------------*/
/*  PROGRAMA:                                                             */
/*           INPUT_SAS_TS_ESTADO_2024.sas	                          	  */
/*------------------------------------------------------------------------*/
/* DESCRICAO: PROGRAMA PARA LEITURA DA TABELA TS_ESTADO DOS MICRODADOS    */
/* DA AEEB 2024                                                           */    
/*                                                                        */
/**************************************************************************/
/**************************************************************************/
/* Observao:                                                            */
/* 		                                                                  */
/* Para abrir os microdados  necessrio salvar este programa e o arquivo */
/* TS_ESTADO.csv no diretrio C:\ do computador.				          */
/*															 			  */                                           
/* Ao terminar esses procedimentos execute o programa salvo utilizando    */
/* as variveis de interesse.                                             */
/**************************************************************************/
/*				                  ATENO                                 */  
/**************************************************************************/
/* Este programa abre a base de Estados(UFs) com os rtulos das variveis de*/
/* acordo com o dicionrio de dados que compem os microdados. Para abrir */
/* os dados sem os rtulos basta importar diretamente no SAS.			  */
/* 																	      */ 																          
/**************************************************************************/

proc format;
	Value TP_SERIE
			2='2 ano do Ensino Fundamental';

	Value ID_TIPO_REDE
			0 = 'Total (Federal, Estadual, Municipal e Privada)'
			1 = 'Federal'
			2 = 'Estadual'
			3 = 'Municipal'
			4 = 'Privada'
			5 = 'Pblica (Estadual e Municipal)'
			6 = 'Pblica (Federal, Estadual e Municipal)';

DATA WORK.TS_ESTADO_2024;
	INFILE 'C:\TS_ESTADO.csv' /*local do arquivo*/
	    LRECL=100
	    FIRSTOBS=2
	    DLM=';'
	    MISSOVER
	    DSD;

INPUT
        NU_ANO_AVALIACAO 		: ?? BEST4.
        CO_UF            		: ?? BEST2.
        SG_UF            		: $CHAR2.
        TP_SERIE         		: ?? BEST1.
        ID_TIPO_REDE     		: ?? BEST1.
        PC_ALUNO_ALFABETIZADO 	: ?? COMMA5.
        VL_MEDIA_LP      		: ?? COMMA8. 
		PC_ALUNO_NIVEL_0_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_1_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_2_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_3_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_4_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_5_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_6_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_7_LP		: ?? COMMA5.
		PC_ALUNO_NIVEL_8_LP		: ?? COMMA5.;

ATTRIB  
        TP_SERIE		FORMAT = TP_SERIE.          
        ID_TIPO_REDE    FORMAT = ID_TIPO_REDE. ;

LABEL
		NU_ANO_AVALIACAO 		= 'Ano de aplicao da avaliao estadual'
		CO_UF            		= 'Cdigo da Unidade da Federao'
		SG_UF            		= 'Sigla da Unidade da Federao'
		TP_SERIE         		= 'Ano Escolar'
		ID_TIPO_REDE     		= 'Rede de ensino avaliada para construo do resultado'
		PC_ALUNO_ALFABETIZADO 	= 'Percentual dos alunos avalados na UF que foram considerados, mediante o resultado da avaliao estadual, como alfabetizados.'
		VL_MEDIA_LP      		= 'Mdia ponderada da UF na avaliao estadual na disciplina Lngua Portuguesa (LP) equalizada com o SAEB.'
		PC_ALUNO_NIVEL_0_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 0 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_1_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 1 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_2_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 2 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_3_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 3 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_4_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 4 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_5_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 5 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_6_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 6 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_7_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 7 na avaliao estadual de Lingua Portuguesa (LP).'
		PC_ALUNO_NIVEL_8_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nvel de desempenho 8 na avaliao estadual de Lingua Portuguesa (LP).';
RUN;