/**************************************************************************/
/*  INEP/CETIC - Centro de Tecnologia, Inovao e Cincia de Dados     	  */      
/*                                   									  */	
/*  Coordenao-Geral de Sistemas e Dados Educacionais (CGSDE)			  */
/*------------------------------------------------------------------------*/
/*  PROGRAMA:                                                             */
/*           INPUT_SAS_TS_ALUNO_2024.sas	                        	  */
/*------------------------------------------------------------------------*/
/* DESCRICAO: PROGRAMA PARA LEITURA DA TABELA TS_ALUNO DOS MICRODADOS DA  */
/* AEEB 2024                                                              */    
/*                                                                        */
/**************************************************************************/
/**************************************************************************/
/* Observao:                                                            */
/* 		                                                                  */
/* Para abrir os microdados  necessrio salvar este programa e o arquivo */
/* TS_ALUNO.csv no diretrio C:\ do computador.				      */
/*															 			  */                                           
/* Ao terminar esses procedimentos execute o programa salvo utilizando    */
/* as variveis de interesse.                                             */
/**************************************************************************/
/*				                  ATENO                                 */  
/**************************************************************************/
/* Este programa abre a base de alunos com os rtulos das variveis de	  */
/* acordo com o dicionrio de dados que compem os microdados. Para abrir */
/* os dados sem os rtulos basta importar diretamente no SAS.			  */
/* 																	      */ 																          
/**************************************************************************/

proc format;
	Value TP_SERIE
			2='2 ano do Ensino Fundamental';

	Value TP_DEPENDENCIA
			1 = 'Federal'
			2 = 'Estadual'
			3 = 'Municipal'
			4 = 'Privada';

	Value IN_PRESENCA_LP
			0='Ausente'
			1='Presente';

	Value IN_PREENCHIMENTO_LP
			0='Prova no preenchida'
			1='Prova preenchida';

	Value IN_ALFABETIZADO
			0='No'
			1='Sim';

DATA WORK.TS_ALUNO_2024;
	INFILE 'C:\TS_ALUNO.csv' /*local do arquivo*/
	    LRECL=200
	    FIRSTOBS=2
	    DLM=';'
	    MISSOVER
	    DSD;

INPUT
        NU_ANO_AVALIACAO 	: ?? BEST4.
        CO_UF            	: ?? BEST2.
        SG_UF            	: $CHAR2.
        ID_ALUNO         	: ?? BEST8.
        TP_SERIE         	: ?? BEST1.
        ID_ESCOLA        	: ?? BEST8.
		TP_DEPENDENCIA		: ?? BEST1.
        CO_MUNICIPIO     	: ?? BEST7.
        NO_MUNICIPIO     	: $CHAR32.
        IN_PRESENCA_LP   	: ?? BEST1.
        IN_PREENCHIMENTO_LP : ?? BEST1.
        CO_CADERNO_LP    	: ?? BEST2.
        VL_PESO_ALUNO_LP 	: ?? COMMA11.
        VL_PROFICIENCIA_LP 	: ?? COMMA11.
        IN_ALFABETIZADO  	: ?? BEST1. ;

ATTRIB  
        TP_SERIE           		FORMAT = TP_SERIE.          
        TP_DEPENDENCIA          FORMAT = TP_DEPENDENCIA.     
        IN_PRESENCA_LP          FORMAT = IN_PRESENCA_LP.     
        IN_PREENCHIMENTO_LP     FORMAT = IN_PREENCHIMENTO_LP.
        IN_ALFABETIZADO         FORMAT = IN_ALFABETIZADO.;

LABEL
		NU_ANO_AVALIACAO 	= 'Ano de aplicao da avaliao estadual'
		CO_UF            	= 'Cdigo da Unidade da Federao'
		SG_UF            	= 'Sigla da Unidade da Federao'
		ID_ALUNO         	= 'Identificador do Aluno'
		TP_SERIE         	= 'Ano Escolar'
		ID_ESCOLA        	= 'Mscara do Cdigoo da Escola (cdigos fictcios)'
		TP_DEPENDENCIA		= 'Dependncia Administrativa da Escola'
		CO_MUNICIPIO     	= 'Cdigo do Municpio onde est localizada a escola.'
		NO_MUNICIPIO     	= 'Nome do Municpio onde est localizada a escola.'
		IN_PRESENCA_LP   	= 'Indicador de presena na prova de Lngua Portuguesa (LP). '
		IN_PREENCHIMENTO_LP = 'Indicador de preenchimento da prova de Lngua Portuguesa (LP). '
		CO_CADERNO_LP    	= 'Cdigo do Caderno atribudo ao aluno na prova de Lngua Portuguesa (LP).'
		VL_PESO_ALUNO_LP 	= 'Peso do aluno na prova de Lngua Portuguesa'
		VL_PROFICIENCIA_LP 	= 'Proficincia do aluno em Lngua Portuguesa (LP) calculada na escala equalizada com o SAEB.'
		IN_ALFABETIZADO  	= 'Indica se o aluno, mediante o resultado da avaliao estadual,  considerado alfabetizado.';
RUN;