#--------------------------------------------------------
#  INEP/CETIC-Centro de Tecnologia, Inovação e Ciência de Dados 
#  Coordenação-Geral de Sistemas e Dados Educacionais (CGSDE)			
#--------------------------------------------------------

#--------------------------------------------------------
#  PROGRAMA:                                                                                                      
#           INPUT_R_TS_ITEM_2024
#--------------------------------------------------------
#  DESCRIÇÃO:
#           PROGRAMA PARA LEITURA DA TABELA TS_ITEM DO AEEB 2024
#--------------------------------------------------------

#------------------------------------------------------------------------
# Observação:                                                                                                                    
#     Para abrir os microdados é necessário salvar o arquivo                    
#     TS_ITEM.csv no diretório especificado. 
#     Ex. Windows C:\
#         Linux /home	                  
#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                   ATENÇãO             
#------------------------------------------------------------------------
# Este programa abre a base de itens com os rótulos das variáveis de	                    
# acordo com o dicionário de dados que compõem os microdados. Para abrir 
# os dados sem os rótulos basta importar diretamente no R. 
#------------------------------------------------------------------------

# Instalação dos pacotes necessários
if(!require(data.table)) install.packages('data.table')
if(!require(forcats)) install.packages('forcats')

library(data.table)
library(forcats)

# Configuração do diretório de trabalho
setwd("C:\\")

# Carga dos microdados
ts_item_2024 <- fread('TS_ITEM.csv', sep = ';', na.strings = c("", "NA"), encoding = "Latin-1")

# Definição dos rótulos das variáveis
#ts_item_2024$TP_SERIE <- factor(ts_item_2024$TP_SERIE, levels = c(2), labels = c('2º ano do Ensino Fundamental'))
#ts_item_2024$TP_DISCIPLINA <- factor(ts_item_2024$TP_DISCIPLINA, levels = c(1), labels = c('Língua Portuguesa (LP)'))
#ts_item_2024$TP_RESPOSTA_ITEM <- factor(ts_item_2024$TP_RESPOSTA_ITEM, levels = c(1,2,3,4), labels = c('Produção Textual','Resposta Construída','Resposta Objetiva','Resposta Construída com Quesito'))
#ts_item_2024$TP_MODELO_TRI <- factor(ts_item_2024$TP_MODELO_TRI, levels = c(1,2,3,4), labels = c('M2PL: Modelo logístico de 2 parâmetros','M3PL: Modelo Logístico de 3 parâmetros','MRG: Modelo de resposta gradual','M3P: modelo normal de 3 parâmetros'))
#ts_item_2024$IN_ITEM_COMUM <- factor(ts_item_2024$IN_ITEM_COMUM, levels = c(0,1), labels = c('Não','Sim'))

# Atribui os labels para as variáveis
labels <- list(
  NU_ANO_AVALIACAO 	= 'Ano de aplicação da avaliação estadual',
  CO_UF            	= 'Código da Unidade da Federação',
  SG_UF            	= 'Sigla da Unidade da Federação',
  CO_BLOCO         	= 'Código do Bloco',
  NU_POSICAO       	= 'Posição do item no Bloco.',
  CO_ITEM          	= 'Código do item',
  TP_SERIE         	= 'Ano Escolar',
  TP_DISCIPLINA    	= 'Indica a disciplina a que corresponde o item',
  NU_DESCRITOR_HABILIDADE = 'Identificador do descritor do item',
  DS_GABARITO      	= 'Gabarito do Item',
  TP_RESPOSTA_ITEM 	= 'Tipo de resposta esperada para o Item',
  TP_MODELO_TRI    	= 'Modelos da Teoria de Resposta ao Item',
  NU_PARAM_A       	= 'Parâmetro de discriminação.',
  NU_PARAM_B       	= 'Parâmetro de dificuldade.',
  NU_PARAM_C       	= 'Parâmetro de acerto ao acaso.',
  NU_PARAM_B1      	= 'Parâmetro de dificuldade da transição entre as categorias de erro e acerto parcial.',
  NU_PARAM_B2      	= 'Parâmetro de dificuldade da transição entre as categorias de acerto parcial e acerto total.',
  NU_PARAM_B3      	= 'Parâmetro de dificuldade da transição entre as categorias de acerto parcial e acerto total.',
  NU_PARAM_B4      	= 'Parâmetro de dificuldade da transição entre as categorias de acerto parcial e acerto total.',
  IN_ITEM_COMUM		= 'Indica se é um item comum com a avaliação do SAEB'
)

# Aplicando LABELS às colunas da tabela
for (var in names(labels)) {
  attr(ts_item_2024[[var]], "label") <- labels[[var]]
}
