#--------------------------------------------------------
#  INEP/CETIC-Centro de Tecnologia, Inovação e Ciência de Dados 
#  Coordenação-Geral de Sistemas e Dados Educacionais (CGSDE)			
#--------------------------------------------------------

#--------------------------------------------------------
#  PROGRAMA:                                                                                                      
#           INPUT_R_TS_ESTADO_2024
#--------------------------------------------------------
#  DESCRIÇÃO:
#           PROGRAMA PARA LEITURA DA TABELA TS_ESTADOO DO AEEB 2024
#--------------------------------------------------------

#------------------------------------------------------------------------
# Observação:                                                                                                                    
#     Para abrir os microdados é necessário salvar o arquivo                    
#     TS_ESTADO.csv no diretório especificado. 
#     Ex. Windows C:\
#         Linux /home	                  
#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                   ATENÇãO             
#------------------------------------------------------------------------
# Este programa abre a base de itens com os rótulos das variáveis de	                    
# acordo com o dicionário de dados que compõem os microdados. Para abrir 
# os dados sem os rótulos basta importar diretamente no R. 
#------------------------------------------------------------------------

# Instalação dos pacotes necessários
if(!require(data.table)) install.packages('data.table')
if(!require(forcats)) install.packages('forcats')

library(data.table)
library(forcats)

# Configuração do diretório de trabalho
setwd("C:\\")

# Carga dos microdados
ts_estado_2024 <- fread('TS_ESTADO.csv', sep = ';', na.strings = c("", "NA"), encoding = "Latin-1")

# Definição dos rótulos das variáveis
#ts_estado_2024$TP_SERIE <- factor(ts_estado_2024$TP_SERIE, levels = c(2), labels = c('2º ano do Ensino Fundamental'))
#ts_estado_2024$ID_TIPO_REDE <- factor(ts_estado_2024$ID_TIPO_REDE, levels = c(1,2,3,4,5,6), labels = c('Federal','Estadual','Municipal','Privada','Pública (Estadual e Municipal)','Pública (Federal, Estadual e Municipal)'))

# Atribui os labels para as variáveis
labels <- list(
  NU_ANO_AVALIACAO 		= 'Ano de aplicação da avaliação estadual',
  CO_UF            		= 'Código da Unidade da Federação',
  SG_UF            		= 'Sigla da Unidade da Federação',
  TP_SERIE         		= 'Ano Escolar',
  ID_TIPO_REDE     		= 'Rede de ensino avaliada para construção do resultado',
  PC_ALUNO_ALFABETIZADO 	= 'Percentual dos alunos avaliados no Estado (UF) que foram considerados, mediante o resultado da avaliação estadual, como alfabetizados.',
  VL_MEDIA_LP      		= 'Média ponderada do Estado (UF) na avaliação estadual na disciplina Língua Portuguesa (LP) equalizada com o SAEB.',
  PC_ALUNO_NIVEL_0_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 0 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_1_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 1 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_2_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 2 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_3_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 3 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_4_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 4 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_5_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 5 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_6_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 6 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_7_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 7 na avaliação estadual de Lingua Portuguesa (LP).',
  PC_ALUNO_NIVEL_8_LP		= 'Percentual de alunos avaliados na UF que foram alocados no nível de desempenho 8 na avaliação estadual de Lingua Portuguesa (LP).'
)

# Aplicando LABELS às colunas da tabela
for (var in names(labels)) {
  attr(ts_estado_2024[[var]], "label") <- labels[[var]]
}
