#--------------------------------------------------------
#  INEP/CETIC-Centro de Tecnologia, Inovação e Ciência de Dados 
#  Coordenação-Geral de Sistemas e Dados Educacionais (CGSDE)			
#--------------------------------------------------------

#--------------------------------------------------------
#  PROGRAMA:                                                                                                      
#           INPUT_R_TS_ALUNO_2024
#--------------------------------------------------------
#  DESCRIÇÃO:
#           PROGRAMA PARA LEITURA DA TABELA TS_ALUNO DO AEEB 2024
#--------------------------------------------------------

#------------------------------------------------------------------------
# Observação:                                                                                                                    
#     Para abrir os microdados é necessário salvar o arquivo                    
#     TS_ALUNO.csv no diretório especificado. 
#     Ex. Windows C:\
#         Linux /home	                  
#------------------------------------------------------------------------

#------------------------------------------------------------------------
#                   ATENÇãO             
#------------------------------------------------------------------------
# Este programa abre a base de itens com os rótulos das variáveis de	                    
# acordo com o dicionário de dados que compõem os microdados. Para abrir 
# os dados sem os rótulos basta importar diretamente no R. 
#------------------------------------------------------------------------

# Instalação dos pacotes necessários
if(!require(data.table)) install.packages('data.table')
if(!require(forcats)) install.packages('forcats')

library(data.table)
library(forcats)

# Configuração do diretório de trabalho
setwd("C:\\")

# Carga dos microdados
ts_aluno_2024 <- fread('TS_ALUNO.csv', sep = ';', na.strings = c("", "NA"), encoding = "Latin-1")

# Definição dos rótulos das variáveis
#ts_aluno_2024$TP_SERIE <- factor(ts_aluno_2024$TP_SERIE, levels = c(2), labels = c('2º ano do Ensino Fundamental'))
#ts_aluno_2024$TP_DEPENDENCIA <- factor(ts_aluno_2024$TP_DEPENDENCIA, levels = c(1,2,3,4), labels = c('Federal','Estadual','Municipal','Privada'))
#ts_aluno_2024$IN_PRESENCA_LP <- factor(ts_aluno_2024$IN_PRESENCA_LP, levels = c(0, 1), labels = c('Ausente','Presente'))
#ts_aluno_2024$IN_PREENCHIMENTO_LP <- factor(ts_aluno_2024$IN_PREENCHIMENTO_LP, levels = c(0, 1), labels = c('Prova não preenchida','Prova preenchida'))
#ts_aluno_2024$IN_ALFABETIZADO <- factor(ts_aluno_2024$IN_ALFABETIZADO, levels = c(0,1), labels = c('Não','Sim'))

# Atribui os labels para as variáveis
labels <- list(
  NU_ANO_AVALIACAO 	= 'Ano de aplicação da avaliação estadual',
  CO_UF            	= 'Código da Unidade da Federação',
  SG_UF            	= 'Sigla da Unidade da Federação',
  ID_ALUNO         	= 'Identificador do Aluno',
  TP_SERIE         	= 'Ano Escolar',
  ID_ESCOLA        	= 'Máscara do Códigoo da Escola (códigos fictícios)',
  TP_DEPENDENCIA		= 'Dependência Administrativa da Escola',
  CO_MUNICIPIO     	= 'Código do Município onde está localizada a escola.',
  NO_MUNICIPIO     	= 'Nome do Município onde está localizada a escola.',
  IN_PRESENCA_LP   	= 'Indicador de presença na prova de Língua Portuguesa (LP).',
  IN_PREENCHIMENTO_LP = 'Indicador de preenchimento da prova de Língua Portuguesa (LP).',
  CO_CADERNO_LP    	= 'Código do Caderno atribuído ao aluno na prova de Língua Portuguesa (LP).',
  VL_PESO_ALUNO_LP 	= 'Peso do aluno na prova de Língua Portuguesa',
  VL_PROFICIENCIA_LP 	= 'Proficiência do aluno em Língua Portuguesa (LP) calculada na escala equalizada com o SAEB.',
  IN_ALFABETIZADO  	= 'Indica se o aluno, mediante o resultado da avaliação estadual, é considerado alfabetizado.'
)

# Aplicando LABELS às colunas da tabela
for (var in names(labels)) {
  attr(ts_aluno_2024[[var]], "label") <- labels[[var]]
}
